#################################################################################
#                                                                               #
#   Reproducible files to the paper 'A computationally fast variable            #
#   importance test for random forests for high-dimensional data' (2015)        #
#   by Janitza, Celik and Boulesteix                                            #
#                                                                               #
#   Contact: S. Janitza <janitza@ibe.med.uni-muenchen.de>                       #
#                                                                               #
#   File for creating Figures 2, B.1, B.9                                       #
#                                                                               #
#################################################################################

# load relevant R package 
library(vita)

# source the functions used for plotting the results 
source("functions_plot.R")

# load relevant R objects
for(i in grep("studyI_", dir("../results/"))) load(paste("../results/", dir("../results/")[i], sep = ""))


######################################################################################################################################
#
#                                                       F I G U R E   2
#
######################################################################################################################################

graphics.off()
pdf(file = "Fig2.pdf", height = 10, width = 5.5)

par(mfrow = c(5, 2), mar = c(3, 6, 2, 0.5))

hist(unlist(sapply(studyI_cv2_smallmtry_prostate, function(z) z$cv_varim)), xlim = c(-0.00015, 0.00015), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), col = "gray90", cex.main = 1.6, main = "Hold-out importance")
mtext(side = 2, text = "Prostate Cancer", line = 4.5, cex = 1)
hist(unlist(studyI_classical_smallmtry_prostate), xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), main = "Classical importance", col = "gray90", cex.main = 1.6)

hist(unlist(sapply(studyI_cv2_smallmtry_breast, function(z) z$cv_varim)), xlim = c(-0.00015, 0.00015), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), main = "", col = "gray90")
mtext(side = 2, text = "Breast Cancer", line = 4.5, cex = 1)
hist(unlist(studyI_classical_smallmtry_breast), xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), col = "gray90", main = "", cex.main = 1.6)

hist(unlist(sapply(studyI_cv2_smallmtry_leukemia, function(z) z$cv_varim)), xlim = c(-0.00015, 0.00015), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), main = "", col = "gray90")
mtext(side = 2, text = "Leukemia", line = 4.5, cex = 1)
hist(unlist(studyI_classical_smallmtry_leukemia), xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), col = "gray90",  main = "", cex.main = 1.6)

hist(unlist(sapply(studyI_cv2_smallmtry_colon, function(z) z$cv_varim)), xlim = c(-0.00015, 0.00015), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), main = "", col = "gray90")
mtext(side = 2, text = "Colon Cancer", line = 4.5, cex = 1)
hist(unlist(studyI_classical_smallmtry_colon), xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), col = "gray90", main = "", cex.main = 1.6)

hist(unlist(sapply(studyI_cv2_smallmtry_cns, function(z) z$cv_varim)), xlim = c(-0.00015, 0.00015), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), main = "", col = "gray90")
mtext(side = 2, text = "Embryonal Tumor", line = 4.5, cex = 1)
hist(unlist(studyI_classical_smallmtry_cns), xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001), col = "gray90", main = "", cex.main = 1.6)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B.1
#
######################################################################################################################################

# for small mtry

graphics.off()
pdf(file = "FigB1upper.pdf", height = 7, width = 10)

par(mfrow = c(5, 5), mar = c(2.5, 1, 0, 0.1), oma = c(0, 2, 9, 0))

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_prostate, 
             obj_cv3 = studyI_cv3_smallmtry_prostate, 
             obj_cv5 = studyI_cv5_smallmtry_prostate, 
             obj_cv10 = studyI_cv10_smallmtry_prostate, 
             obj_classical = studyI_classical_smallmtry_prostate, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_breast, 
             obj_cv3 = studyI_cv3_smallmtry_breast, 
             obj_cv5 = studyI_cv5_smallmtry_breast, 
             obj_cv10 = studyI_cv10_smallmtry_breast, 
             obj_classical = studyI_classical_smallmtry_breast, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_leukemia, 
             obj_cv3 = studyI_cv3_smallmtry_leukemia, 
             obj_cv5 = studyI_cv5_smallmtry_leukemia, 
             obj_cv10 = studyI_cv10_smallmtry_leukemia, 
             obj_classical = studyI_classical_smallmtry_leukemia, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_colon, 
             obj_cv3 = studyI_cv3_smallmtry_colon, 
             obj_cv5 = studyI_cv5_smallmtry_colon, 
             obj_cv10 = studyI_cv10_smallmtry_colon, 
             obj_classical = studyI_classical_smallmtry_colon, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_cns, 
             obj_cv3 = studyI_cv3_smallmtry_cns, 
             obj_cv5 = studyI_cv5_smallmtry_cns, 
             obj_cv10 = studyI_cv10_smallmtry_cns, 
             obj_classical = studyI_classical_smallmtry_cns, ylabel = "", heading = FALSE, xaxt = NULL, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

mtext(side = 2, text = "          Embryonal Tumor      Colon Cancer          Leukemia           Breast Cancer      Prostate Cancer", outer = TRUE, cex = 0.8)
mtext(side = 3, text = "  Hold-out importance      3-fold CV importance         5-fold CV importance       10-fold CV importance      Classical importance", outer = TRUE, cex = 1, line = 1.5)
mtext(side = 3, text = expression(paste("mtry = ", sqrt(p))), outer = TRUE, cex = 1.6, line = 5.5)

graphics.off()


# for large mtry

graphics.off()
pdf(file = "FigB1lower.pdf", height = 7, width = 10)

par(mfrow = c(5, 5), mar = c(2.5, 1, 0, 0.1), oma = c(0, 2, 9, 0))

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_prostate, 
             obj_cv3 = studyI_cv3_largemtry_prostate, 
             obj_cv5 = studyI_cv5_largemtry_prostate, 
             obj_cv10 = studyI_cv10_largemtry_prostate, 
             obj_classical = studyI_classical_largemtry_prostate, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_breast, 
             obj_cv3 = studyI_cv3_largemtry_breast, 
             obj_cv5 = studyI_cv5_largemtry_breast, 
             obj_cv10 = studyI_cv10_largemtry_breast, 
             obj_classical = studyI_classical_largemtry_breast, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_leukemia, 
             obj_cv3 = studyI_cv3_largemtry_leukemia, 
             obj_cv5 = studyI_cv5_largemtry_leukemia, 
             obj_cv10 = studyI_cv10_largemtry_leukemia, 
             obj_classical = studyI_classical_largemtry_leukemia, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_colon, 
             obj_cv3 = studyI_cv3_largemtry_colon, 
             obj_cv5 = studyI_cv5_largemtry_colon, 
             obj_cv10 = studyI_cv10_largemtry_colon, 
             obj_classical = studyI_classical_largemtry_colon, ylabel = "", heading = FALSE, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_cns, 
             obj_cv3 = studyI_cv3_largemtry_cns, 
             obj_cv5 = studyI_cv5_largemtry_cns, 
             obj_cv10 = studyI_cv10_largemtry_cns, 
             obj_classical = studyI_classical_largemtry_cns, ylabel = "", heading = FALSE, xaxt = NULL, xlim = c(-0.0001, 0.0001), breaks = seq(from = -0.500005, to = 0.5, by = 0.00001))

mtext(side = 2, text = "          Embryonal Tumor      Colon Cancer          Leukemia           Breast Cancer      Prostate Cancer", outer = TRUE, cex = 0.8)
mtext(side = 3, text = "  Hold-out importance      3-fold CV importance         5-fold CV importance       10-fold CV importance      Classical importance", outer = TRUE, cex = 1, line = 1.5)
mtext(side = 3, text = expression(paste("mtry = ", p/5)), outer = TRUE, cex = 1.6, line = 5.5)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B.9
#
######################################################################################################################################

# for small mtry

graphics.off()
pdf(file = "FigB9upper.pdf", height = 7, width = 10)

par(mfrow = c(5, 5), mar = c(2.5, 1, 0, 0.1), oma = c(0, 2, 9, 0))

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_p100_prostate, 
             obj_cv3 = studyI_cv3_smallmtry_p100_prostate, 
             obj_cv5 = studyI_cv5_smallmtry_p100_prostate, 
             obj_cv10 = studyI_cv10_smallmtry_p100_prostate, 
             obj_classical = studyI_classical_smallmtry_p100_prostate, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_p100_breast, 
             obj_cv3 = studyI_cv3_smallmtry_p100_breast, 
             obj_cv5 = studyI_cv5_smallmtry_p100_breast, 
             obj_cv10 = studyI_cv10_smallmtry_p100_breast, 
             obj_classical = studyI_classical_smallmtry_p100_breast, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_p100_leukemia, 
             obj_cv3 = studyI_cv3_smallmtry_p100_leukemia, 
             obj_cv5 = studyI_cv5_smallmtry_p100_leukemia, 
             obj_cv10 = studyI_cv10_smallmtry_p100_leukemia, 
             obj_classical = studyI_classical_smallmtry_p100_leukemia, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_p100_colon, 
             obj_cv3 = studyI_cv3_smallmtry_p100_colon, 
             obj_cv5 = studyI_cv5_smallmtry_p100_colon, 
             obj_cv10 = studyI_cv10_smallmtry_p100_colon, 
             obj_classical = studyI_classical_smallmtry_p100_colon, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_smallmtry_p100_cns, 
             obj_cv3 = studyI_cv3_smallmtry_p100_cns, 
             obj_cv5 = studyI_cv5_smallmtry_p100_cns, 
             obj_cv10 = studyI_cv10_smallmtry_p100_cns, 
             obj_classical = studyI_classical_smallmtry_p100_cns, ylabel = "", heading = FALSE, xaxt = NULL)

mtext(side = 2, text = "          Embryonal Tumor      Colon Cancer          Leukemia           Breast Cancer      Prostate Cancer", outer = TRUE, cex = 0.8)
mtext(side = 3, text = "  Hold-out importance      3-fold CV importance         5-fold CV importance       10-fold CV importance      Classical importance", outer = TRUE, cex = 1, line = 1.5)
mtext(side = 3, text = expression(paste("mtry = ", sqrt(100))), outer = TRUE, cex = 1.6, line = 5.5)

graphics.off()


# for large mtry

graphics.off()
pdf(file = "FigB9lower.pdf", height = 7, width = 10)

par(mfrow = c(5, 5), mar = c(2.5, 1, 0, 0.1), oma = c(0, 2, 9, 0))

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_p100_prostate, 
             obj_cv3 = studyI_cv3_largemtry_p100_prostate, 
             obj_cv5 = studyI_cv5_largemtry_p100_prostate, 
             obj_cv10 = studyI_cv10_largemtry_p100_prostate, 
             obj_classical = studyI_classical_largemtry_p100_prostate, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_p100_breast, 
             obj_cv3 = studyI_cv3_largemtry_p100_breast, 
             obj_cv5 = studyI_cv5_largemtry_p100_breast, 
             obj_cv10 = studyI_cv10_largemtry_p100_breast, 
             obj_classical = studyI_classical_largemtry_p100_breast, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_p100_leukemia, 
             obj_cv3 = studyI_cv3_largemtry_p100_leukemia, 
             obj_cv5 = studyI_cv5_largemtry_p100_leukemia, 
             obj_cv10 = studyI_cv10_largemtry_p100_leukemia, 
             obj_classical = studyI_classical_largemtry_p100_leukemia, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_p100_colon, 
             obj_cv3 = studyI_cv3_largemtry_p100_colon, 
             obj_cv5 = studyI_cv5_largemtry_p100_colon, 
             obj_cv10 = studyI_cv10_largemtry_p100_colon, 
             obj_classical = studyI_classical_largemtry_p100_colon, ylabel = "", heading = FALSE)

plot_cv_hist(obj_cv2 = studyI_cv2_largemtry_p100_cns, 
             obj_cv3 = studyI_cv3_largemtry_p100_cns, 
             obj_cv5 = studyI_cv5_largemtry_p100_cns, 
             obj_cv10 = studyI_cv10_largemtry_p100_cns, 
             obj_classical = studyI_classical_largemtry_p100_cns, ylabel = "", heading = FALSE, xaxt = NULL)

mtext(side = 2, text = "          Embryonal Tumor      Colon Cancer          Leukemia           Breast Cancer      Prostate Cancer", outer = TRUE, cex = 0.8)
mtext(side = 3, text = "  Hold-out importance      3-fold CV importance         5-fold CV importance       10-fold CV importance      Classical importance", outer = TRUE, cex = 1, line = 1.5)
mtext(side = 3, text = expression(paste("mtry = ", 100/5)), outer = TRUE, cex = 1.6, line = 5.5)

graphics.off()
