#################################################################################
#                                                                               #
#   Reproducible files to the paper 'A computationally fast variable            #
#   importance test for random forests for high-dimensional data' (2015)        #
#   by Janitza, Celik and Boulesteix                                            #
#                                                                               #
#   Contact: S. Janitza <janitza@ibe.med.uni-muenchen.de>                       #
#                                                                               #
#   File for creating Figures 6 - 8, B.11, B.4 - B.8, B.14 - B.18               #
#                                                                               #
#################################################################################

# load relevant R package 
library(vita)

# source the functions used for plotting the results 
source("functions_plot.R")

# load relevant R objects
for(i in grep("studyII_", dir("../results/"))) load(paste("../results/", dir("../results/")[i], sep = ""))
for(i in grep("studyIII_", dir("../results/"))) load(paste("../results/", dir("../results/")[i], sep = ""))

######################################################################################################################################
#
#                                                       F I G U R E   6
#
######################################################################################################################################

# small mtry

graphics.off()
pdf(file = "Fig6upper.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_prostate[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_breast[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_leukemia[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_colon[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_cns[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Embryonal Tumor", ylab = FALSE,
           legend = FALSE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, expression(paste("mtry = ", sqrt(p))), outer = TRUE, line = 2)

graphics.off()


# large mtry

graphics.off()
pdf(file = "Fig6lower.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_prostate[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_breast[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_leukemia[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_colon[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_cns[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Embryonal Tumor", ylab = FALSE,
           legend = TRUE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, "mtry = p/5", outer = TRUE, line = 2)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   7
#
######################################################################################################################################

# small mtry

graphics.off()
pdf(file = "Fig7upper.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_prostate[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_breast[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_leukemia[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_colon[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_cns[[z]])),
           altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Embryonal Tumor", ylab = FALSE,
           legend = FALSE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, expression(paste("mtry = ", sqrt(100))), outer = TRUE, line = 2)

graphics.off()


# large mtry

graphics.off()
pdf(file = "Fig7lower.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")


plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_prostate[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_breast[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_leukemia[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_colon[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_cns[[z]])),
           altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Embryonal Tumor", ylab = FALSE,
           legend = TRUE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, "mtry = 100/5", outer = TRUE, line = 2)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   8
#
######################################################################################################################################

# small mtry

graphics.off()
pdf(file = "Fig8upper.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_prostate[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_breast[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_leukemia[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_colon[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_cns[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Embryonal Tumor", ylab = FALSE,
           legend = FALSE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, expression(paste("mtry = ", sqrt(p))), outer = TRUE, line = 2)

graphics.off()


# large mtry

graphics.off()
pdf(file = "Fig8lower.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_prostate[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_breast[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_leukemia[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_colon[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_cns[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, ymax = 0.4, main = "Embryonal Tumor", ylab = FALSE,
           legend = TRUE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, "mtry = p/5", outer = TRUE, line = 2)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B.11
#
######################################################################################################################################

# small mtry

graphics.off()
pdf(file = "FigB11upper.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_p100_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_p100_prostate[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_p100_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_p100_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_p100_breast[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_p100_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_p100_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_p100_leukemia[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_p100_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_p100_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_p100_colon[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_p100_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_smallmtry_largeeffects_p100_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_smallmtry_largeeffects_p100_cns[[z]])),
           altmann_pval = studyII_pimp_smallmtry_largeeffects_p100_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Embryonal Tumor", ylab = FALSE,
           legend = FALSE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, expression(paste("mtry = ", sqrt(100))), outer = TRUE, line = 2)

graphics.off()


# large mtry

graphics.off()
pdf(file = "FigB11lower.pdf", height = 3, width = 10)

par(mfrow = c(1, 5), mar = c(4, 2, 2, 0.5), oma = c(0, 4, 0, 0), bty = "l")

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_p100_prostate[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_p100_prostate[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_p100_prostate,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Prostate Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_p100_breast[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_p100_breast[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_p100_breast,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Breast Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_p100_leukemia[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_p100_leukemia[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_p100_leukemia,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Leukemia", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_p100_colon[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_p100_colon[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_p100_colon,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Colon Cancer", ylab = FALSE)

plot_power(holdout_pval = lapply(1:500, function(z) NTA(studyII_cv2_largemtry_largeeffects_p100_cns[[z]]$cv_varim)$pvalue), 
           naive_pval   = lapply(1:500, function(z) compute_pvalue(studyII_classical_largemtry_largeeffects_p100_cns[[z]])),
           altmann_pval = studyII_pimp_largemtry_largeeffects_p100_cns,  
           effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, ymax = 0.8, main = "Embryonal Tumor", ylab = FALSE,
           legend = TRUE)

mtext(side = 2, "Proportion of rejections", outer = TRUE, line = 0.5, cex = 0.8)
mtext(side = 2, "mtry = 100/5", outer = TRUE, line = 2)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B.4 - B.8
#
######################################################################################################################################

## prostate cancer data

graphics.off()
pdf(file = "FigB4upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_prostate[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_prostate[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_prostate,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", sqrt(p))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB4lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_prostate[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_prostate[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_prostate,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", p/5)), ylab = FALSE)

graphics.off()


## breast cancer data 

graphics.off()
pdf(file = "FigB5upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_breast[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_breast[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_breast,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", sqrt(p))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB5lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_breast[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_breast[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_breast,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", p/5)), ylab = FALSE)

graphics.off()


# leukemia data

graphics.off()
pdf(file = "FigB6upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_leukemia[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_leukemia[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_leukemia,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100,  mtext = expression(paste("mtry = ", sqrt(p))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB6lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_leukemia[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_leukemia[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_leukemia,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100,  mtext = expression(paste("mtry = ", p/5)), ylab = FALSE)

graphics.off()


# colon cancer data

graphics.off()
pdf(file = "FigB7upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_colon[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_colon[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_colon,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", sqrt(p))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB7lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_colon[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_colon[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_colon,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", p/5)), ylab = FALSE)

graphics.off()


# embryonal tumor data 

graphics.off()
pdf(file = "FigB8upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_cns[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_cns[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_cns,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", sqrt(p))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB8lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_cns[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_cns[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_cns,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", p/5)), ylab = FALSE)

graphics.off()


######################################################################################################################################
#
#                                                       F I G U R E   B.14 - B.18
#
######################################################################################################################################

## prostate cancer data

graphics.off()
pdf(file = "FigB14upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_prostate[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_prostate[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_prostate,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, mtext = expression(paste("mtry = ", sqrt(100))), ylab = FALSE, maxsel = 5, legend = FALSE)

graphics.off()
pdf(file = "FigB14lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_prostate[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_prostate[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_prostate,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 20, mtext = expression(paste("mtry = ", 100/5)), ylab = FALSE, maxsel = 5)

graphics.off()


## breast cancer data 

graphics.off()
pdf(file = "FigB15upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_breast[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_breast[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_breast,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", sqrt(100))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB15lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_breast[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_breast[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_breast,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", 100/5)), ylab = FALSE)

graphics.off()


# leukemia data

graphics.off()
pdf(file = "FigB16upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_leukemia[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_leukemia[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_leukemia,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100,  mtext = expression(paste("mtry = ", sqrt(100))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB16lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_leukemia[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_leukemia[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_leukemia,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100,  mtext = expression(paste("mtry = ", 100/5)), ylab = FALSE)

graphics.off()


# colon cancer data

graphics.off()
pdf(file = "FigB17upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_colon[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_colon[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_colon,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", sqrt(100))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB17lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_colon[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_colon[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_colon,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", 100/5)), ylab = FALSE)

graphics.off()


# embryonal tumor data 

graphics.off()
pdf(file = "FigB18upper.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_smallmtry_largeeffects_p100_cns[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_smallmtry_largeeffects_p100_cns[[z]])),
              altmann_pval = studyIII_pimp_smallmtry_largeeffects_p100_cns,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", sqrt(100))), ylab = FALSE, legend = FALSE)

graphics.off()
pdf(file = "FigB18lower.pdf", height = 6, width = 7)

barplot_power(holdout_pval = lapply(1:500, function(z) NTA(studyIII_cv2_largemtry_largeeffects_p100_cns[[z]]$cv_varim)$pvalue), 
              naive_pval   = lapply(1:500, function(z) compute_pvalue(studyIII_classical_largemtry_largeeffects_p100_cns[[z]])),
              altmann_pval = studyIII_pimp_largemtry_largeeffects_p100_cns,  
              effectset = c(-0.5, -1, -2, -3, 0.5, 1, 2, 3), nsignal = 100, mtext = expression(paste("mtry = ", 100/5)), ylab = FALSE)

graphics.off()
